/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.entities.ai.AvoidAndApproachTargetGoal;
import com.pikachu.mod.illager_more.entities.projectile.BulletProjectile;
import com.pikachu.mod.illager_more.init.ModEntityTypes;
import com.pikachu.mod.illager_more.init.ModItems;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class CowboyEntity
extends AbstractIllager
implements IAnimatable {
    public static final EntityDataAccessor<Boolean> IS_PULLED_OUT_WEAPON = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_PULLING_OUT_WEAPON = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_WITHDRAW_WEAPON = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DODGE = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DASH = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_ATTACK = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_RELOAD = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_ATTACK_P = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DODGE_TICK = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DASH_TICK = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ATTACK_COOLDOWN = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DODGE_COOLDOWN = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DASH_COOLDOWN = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(CowboyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int timer = 0;
    protected int bulletNum = 6;
    protected int MemoryTimeAfterTargetDisappears;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public CowboyEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 15;
        this.MemoryTimeAfterTargetDisappears = 0;
    }

    public boolean m_7307_(Entity p_33314_) {
        if (super.m_7307_(p_33314_)) {
            return true;
        }
        if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == MobType.f_21643_ || p_33314_ instanceof Raider) {
            return this.m_5647_() == null && p_33314_.m_5647_() == null;
        }
        return false;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new ReloadGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DoHurtTargetGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PullOutWeaponGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new WithdrawWeaponGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DodgeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DashGoal(this));
        this.f_21345_.m_25352_(5, new AvoidAndApproachTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 8.5f, 0.675, 1.1, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.f_19853_.m_5776_()) {
            if (this.m_5448_() != null) {
                this.MemoryTimeAfterTargetDisappears = this.f_19797_ + 80;
            }
            this.CooldownReduction();
            this.TickReduction();
        } else {
            boolean b;
            boolean bl = b = (Integer)this.f_19804_.m_135370_(ATTACK_TYPE) == 1 && this.timer == 2 && (Integer)this.f_19804_.m_135370_(ATTACK_TYPE) == 2 && (this.timer == 9 || this.timer == 11 || this.timer == 13 || this.timer == 15 || this.timer == 17 || this.timer == 19) && (Boolean)this.f_19804_.m_135370_(IS_ATTACK) != false;
            if (b) {
                Vec3 pos = CombatEvent.getOffsetPos((Entity)this, 0.0, 1.335, 1.45, this.f_20883_);
                float dodgeYaw = (float)Math.toRadians(this.f_20883_ % 360.0f + 90.0f);
                float speed = 1.5f;
                for (int i = 0; i < 12; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), (this.m_217043_().m_188583_() + (double)speed * Math.cos(dodgeYaw)) * 0.05, this.m_217043_().m_188583_() * 0.05, (this.m_217043_().m_188583_() + (double)speed * Math.sin(dodgeYaw)) * 0.05);
                }
                this.f_19804_.m_135381_(IS_ATTACK_P, (Object)false);
            }
        }
    }

    protected void CooldownReduction() {
        if ((Integer)this.f_19804_.m_135370_(DASH_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(DASH_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DASH_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(ATTACK_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(ATTACK_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(ATTACK_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DODGE_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(DODGE_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DODGE_COOLDOWN) - 1));
        }
    }

    protected void TickReduction() {
        if ((Integer)this.f_19804_.m_135370_(DASH_TICK) > 0) {
            this.f_19804_.m_135381_(DASH_TICK, (Object)((Integer)this.f_19804_.m_135370_(DASH_TICK) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) > 0) {
            this.f_19804_.m_135381_(ATTACK_TICK, (Object)((Integer)this.f_19804_.m_135370_(ATTACK_TICK) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DODGE_TICK) > 0) {
            this.f_19804_.m_135381_(DODGE_TICK, (Object)((Integer)this.f_19804_.m_135370_(DODGE_TICK) - 1));
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "r", 0.0f, this::predicateRot));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.COWBOY_HAT.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.COWBOY_ROBES.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.COWBOY_PANTS.get()));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.COWBOY_SHOES.get()));
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_DASH, (Object)false);
        this.f_19804_.m_135372_(IS_DODGE, (Object)false);
        this.f_19804_.m_135372_(IS_ATTACK, (Object)false);
        this.f_19804_.m_135372_(IS_ATTACK_P, (Object)false);
        this.f_19804_.m_135372_(IS_RELOAD, (Object)false);
        this.f_19804_.m_135372_(IS_PULLED_OUT_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_PULLING_OUT_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_WITHDRAW_WEAPON, (Object)false);
        this.f_19804_.m_135372_(DASH_TICK, (Object)0);
        this.f_19804_.m_135372_(DODGE_TICK, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
        this.f_19804_.m_135372_(DASH_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(DODGE_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(ATTACK_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimationSpeed(1.0);
        CowboyEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (((Boolean)this.f_19804_.m_135370_(IS_PULLING_OUT_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("pull_out_weapon", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_WITHDRAW_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("pull_down_weapon", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_RELOAD)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("reload_bullet", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_ATTACK)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Integer)this.f_19804_.m_135370_(ATTACK_TYPE) == 1 ? "attack" : "attack_fast", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dodge", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dash", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed(Math.max((double)(groundSpeed * 20.0f), 0.15));
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "walk_pulled_out_weapon" : "walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "idle_pulled_out_weapon" : "idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState predicateRot(AnimationEvent<P> event) {
        event.getController().animationSpeed = 1.0;
        if (((Boolean)this.f_19804_.m_135370_(IS_RELOAD)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot4", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot2", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot3", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22281_, 1.5);
    }

    @Nonnull
    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource p_184601_1_) {
        return SoundEvents.f_12579_;
    }

    static class ReloadGoal
    extends Goal {
        private final CowboyEntity mob;

        public ReloadGoal(CowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) && this.mob.bulletNum < 6 || this.mob.bulletNum <= 0;
        }

        public boolean m_6767_() {
            return this.mob.timer >= 10;
        }

        public boolean m_8045_() {
            return this.mob.timer < 20;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_RELOAD, (Object)Boolean.TRUE);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_RELOAD, (Object)false);
            this.mob.bulletNum = 6;
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.timer == 2) {
                this.mob.m_5496_(SoundEvents.f_12482_, 1.0f, 1.0f);
            }
            this.sound(7);
            this.sound(9);
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }

        protected void sound(int i) {
            if (this.mob.timer == i) {
                this.mob.m_5496_(SoundEvents.f_12444_, 1.0f, 1.0f);
            }
        }
    }

    static class DoHurtTargetGoal
    extends Goal {
        protected final CowboyEntity mob;
        protected int type;
        protected boolean canMoving;
        protected boolean hasNext;

        public DoHurtTargetGoal(CowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (this.mob.m_217043_().m_188499_() || (double)this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 16.5) && (double)this.mob.m_20270_((Entity)this.mob.m_5448_()) >= 6.5 && this.mob.m_142582_((Entity)this.mob.m_5448_()) && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && (Integer)this.mob.f_19804_.m_135370_(ATTACK_COOLDOWN) <= 0;
        }

        public boolean m_8045_() {
            if (!this.hasNext) {
                return this.isAttacking() && this.mob.m_5448_() != null;
            }
            if (!this.isAttacking()) {
                this.mob.timer = 0;
                ++this.type;
                if (this.mob.bulletNum <= 0) {
                    return false;
                }
                return this.mob.m_217043_().m_188499_() && this.mob.m_5448_() != null && this.mob.m_5448_().f_20916_ > 0;
            }
            return this.mob.m_5448_() != null;
        }

        private boolean isAttacking() {
            return this.mob.timer < (this.type == 1 ? 10 : 25) + 1 - this.mob.m_217043_().m_188503_(3) && this.mob.bulletNum > 0;
        }

        public boolean m_6767_() {
            return this.mob.f_20916_ > 0 && this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) < 6.0f;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.type = this.mob.m_217043_().m_188503_(10) == 0 ? 2 : 1;
            this.mob.f_19804_.m_135381_(IS_ATTACK, (Object)true);
            this.mob.f_19804_.m_135381_(ATTACK_TYPE, (Object)1);
        }

        public void m_8037_() {
            ++this.mob.timer;
            if (this.type == 1) {
                this.attack(2);
                this.hasNext = false;
                this.canMoving = false;
            } else if (this.type == 2) {
                this.attack(9);
                this.attack(11);
                this.attack(13);
                this.attack(15);
                this.attack(17);
                this.attack(19);
                this.hasNext = false;
            }
            if (this.mob.m_5448_() == null) {
                this.hasNext = false;
            }
            if (!this.canMoving) {
                this.mob.m_21573_().m_26573_();
            }
            if (this.mob.m_5448_() != null) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
            }
            this.mob.f_19804_.m_135381_(ATTACK_TYPE, (Object)this.type);
        }

        private void attack(int i) {
            if (this.mob.timer == i) {
                if (this.mob.m_5448_() == null) {
                    return;
                }
                if (this.mob.bulletNum <= 0) {
                    this.mob.m_5496_(SoundEvents.f_12443_, 2.0f, 2.5f);
                    return;
                }
                Vec3 pos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 1.335, 1.45, this.mob.f_20883_);
                double d1 = this.mob.m_5448_().m_20185_() - pos.f_82479_;
                double d2 = this.mob.m_5448_().m_20227_(0.6) - pos.f_82480_;
                double d3 = this.mob.m_5448_().m_20189_() - pos.f_82481_;
                BulletProjectile bulletProjectile = new BulletProjectile((EntityType<? extends BulletProjectile>)((EntityType)ModEntityTypes.BULLET.get()), (LivingEntity)this.mob, d1, d2, d3, this.mob.f_19853_);
                bulletProjectile.m_20219_(pos);
                bulletProjectile.m_5602_((Entity)this.mob);
                this.mob.f_19853_.m_7967_((Entity)bulletProjectile);
                --this.mob.bulletNum;
                this.mob.m_5496_(SoundEvents.f_12313_, 3.0f, 2.5f);
            }
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_ATTACK, (Object)false);
            this.mob.f_19804_.m_135381_(ATTACK_COOLDOWN, (Object)6);
        }
    }

    static class PullOutWeaponGoal
    extends Goal {
        private final CowboyEntity mob;

        public PullOutWeaponGoal(CowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) == false;
        }

        public boolean m_6767_() {
            return this.mob.timer >= 10;
        }

        public boolean m_8045_() {
            return this.mob.timer < 20;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)true);
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class WithdrawWeaponGoal
    extends Goal {
        private final CowboyEntity mob;

        public WithdrawWeaponGoal(CowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && this.mob.MemoryTimeAfterTargetDisappears <= this.mob.f_19797_;
        }

        public boolean m_8045_() {
            return this.mob.timer < 20;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_WITHDRAW_WEAPON, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)false);
            this.mob.f_19804_.m_135381_(IS_WITHDRAW_WEAPON, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class DodgeGoal
    extends Goal {
        private final CowboyEntity mob;
        private float dodgeYaw;

        public DodgeGoal(CowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return ((this.mob.m_20069_() || this.mob.m_20077_()) && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 12.0f || this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 7.0f || this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 13.0f && this.mob.f_20916_ > 0) && (Integer)this.mob.f_19804_.m_135370_(DODGE_COOLDOWN) <= 0 && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 12;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DODGE, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DODGE, (Object)false);
            this.mob.f_19804_.m_135381_(DODGE_COOLDOWN, (Object)30);
            this.mob.f_19804_.m_135381_(DASH_COOLDOWN, (Object)35);
            this.mob.f_19804_.m_135381_(DODGE_TICK, (Object)8);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.mob.timer == 1) {
                this.dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 150.0f - 75.0f);
            }
            if (this.mob.timer == 6 && (this.mob.m_20096_() || this.mob.m_20077_() || this.mob.m_20069_())) {
                float speed = -2.5f;
                Vec3 m = this.mob.m_20184_().m_82520_((double)speed * Math.cos(this.dodgeYaw), 0.0, (double)speed * Math.sin(this.dodgeYaw));
                this.mob.m_20334_(m.f_82479_, 0.1, m.f_82481_);
            }
        }
    }

    static class DashGoal
    extends Goal {
        private final CowboyEntity mob;

        public DashGoal(CowboyEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 32.0f || this.mob.m_20077_() || this.mob.m_20069_()) && (Integer)this.mob.f_19804_.m_135370_(DASH_COOLDOWN) <= 0;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 12;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DASH, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DASH, (Object)false);
            this.mob.f_19804_.m_135381_(DASH_COOLDOWN, (Object)30);
            this.mob.f_19804_.m_135381_(DASH_TICK, (Object)8);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            float dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 150.0f - 75.0f);
            if (this.mob.timer == 6 && (this.mob.m_20096_() || this.mob.m_20077_() || this.mob.m_20069_())) {
                float speed = 2.5f;
                Vec3 m = this.mob.m_20184_().m_82520_((double)speed * Math.cos(dodgeYaw), 0.0, (double)speed * Math.sin(dodgeYaw));
                this.mob.m_20334_(m.f_82479_, 0.1, m.f_82481_);
            }
        }
    }
}

